/* BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
// Read a lineage tree in EMB format and Export Centers with ID

#include "dirent.h"
#include "string.h"
#include "stdio.h"
#include "stdlib.h"
#include "sys/stat.h"

#include <iostream>
#include <sstream>
#include <string>
#include <fstream>

#include <map>
#include <list>
#include <vector>

#include "math.h"
#include <time.h>
#include <algorithm>

#include <stdarg.h>

#include <cstring>


using namespace std;

vector<string> split(string str,string delims);
float * EmptyVector();
float * EmptyVector(int n);
char * ReadArg(int argc, char* argv[] , string Name);

int main( int argc, char *argv[] )
{
    
    if(argc<3){
        printf("COMMAND : ExportMOVITCenters --inputfile <inputfile.emb>  --outputcenters <centersformat.txt> --outputID <IDfile.txt> --SpacingX <SpacingX> --SpacingY <SpacingY> --SpacingZ <SpacingZ> --ImageSizeX <ImageSizeX> --ImageSizeY <ImageSizeY> --ImageSizeZ <ImageSizeZ>\n");
        /*argv[1]="--inputfile";
        argv[2]="/Users/emmanuelfaure/Bioemergences-Worfklow/cache/080611b_Local/080611b_Localn0t1.emb";
        argv[3]="--outputcenters";
        argv[4]="/Users/emmanuelfaure/DATA/080611b/output/Nuclei/Segmentation/NucleiSegmentation/Centers/Centers_t%03d.txt";
        argv[5]="--outputID";
        argv[6]="/Users/emmanuelfaure/DATA/080611b/output/Nuclei/Segmentation/NucleiSegmentation/IDS/IDS_t%03d.txt";
        argv[7]="--ImageSizeX";
        argv[8]="512";
        argv[9]="--ImageSizeY";
        argv[10]="512";
        argv[11]="--ImageSizeZ";
        argv[12]="79";
        argc=13;*/
        return -1;
    }
    
    char * inputfile=ReadArg(argc,argv,"inputfile");
    char * outputcenters=ReadArg(argc,argv,"outputcenters");
    char * outputID=ReadArg(argc,argv,"outputID");
    float * ImageSize=EmptyVector();
    ImageSize[0]=atof(ReadArg(argc,argv,"ImageSizeX"));
    ImageSize[1]=atof(ReadArg(argc,argv,"ImageSizeY"));
    ImageSize[2]=atof(ReadArg(argc,argv,"ImageSizeZ"));
    
    
    
    char *buffer = (char *)malloc(4096);
    FILE *fp = fopen(inputfile,"r");
    printf("ExportMOVITCenters -> READ %s \n",inputfile);
    fgets(buffer,4096,fp);
    //Cell ID, Cell Mother ID, X, Y, Z, Time, Vx, Vy, vZ, Virtual, Name, Center Number,Deformation, Distance
    //Lines 0;0;0;0;0;10;0;0 to separate each time step
    //ID;CN;X;Y;Z;TIME;MOTHER

    map< long , map<long, long > > TimeCenter;
    
    map< long , float * > CoordXYZ;
    
    long minTime=10000000;long maxTime=-1000000;
    long CN=1;
    while(!feof(fp)){
        std::vector<string> TabSpliter=split(buffer,";");
        long ID=atol(TabSpliter[0].c_str());
        long time=atol(TabSpliter[5].c_str());
        if(ID==0) { //Time Separator
            if(time<minTime)minTime=time;
            if(time>maxTime)maxTime=time;
            CN=1;
        }else{
            float *XYZ=EmptyVector();
            XYZ[0]=round(atof(TabSpliter[2].c_str())+ImageSize[0]/2);
            XYZ[1]=round(atof(TabSpliter[3].c_str())+ImageSize[1]/2);
            XYZ[2]=round(atof(TabSpliter[4].c_str()));
            TimeCenter[time][ID]=CN;
            CoordXYZ[ID]=XYZ;
            CN++;
        }
        fgets(buffer,4096,fp);
        TabSpliter.clear();
    }
    fclose(fp);

    printf(" Found %d cells bewteen time %ld and  %ld \n",CoordXYZ.size(),minTime,maxTime);
    //Write the IDs Coorespondands and export the centetrs
    
    char file_name[400];char file_nameID[400];
    for(long time=minTime;time<=maxTime;time++){
            sprintf(file_name,outputcenters,time);
            FILE *fpcenters= fopen(file_name,"w");

            sprintf(file_nameID,outputID,time);
            FILE *fpoutputID= fopen(file_nameID,"w");
            for(std::map<long,long>::iterator it = TimeCenter[time].begin(); it!= TimeCenter[time].end(); ++it){
                long ID =(*it).first;
                long CN=(*it).second;
                float * XYZ=CoordXYZ[ID];
                fprintf(fpoutputID,"%ld;%ld\n",ID,CN);
                fprintf(fpcenters,"%d %d %d\n",(int)XYZ[0],(int)XYZ[1],(int)XYZ[2]);
            }
            fclose(fpcenters);
            fclose(fpoutputID);

    }

   
    
    return 0;
    
}


vector<string> split(string str,string delims)
{
    // Skip delims at beginning, find start of first token
    string::size_type lastPos = str.find_first_not_of(delims, 0);
    // Find next delimiter @ end of token
    string::size_type pos     = str.find_first_of(delims, lastPos);
    
    // output vector
    vector<string> tokens;
    
    while (string::npos != pos || string::npos != lastPos)
    {
        // Found a token, add it to the vector.
        tokens.push_back(str.substr(lastPos, pos - lastPos));
        // Skip delims.  Note the "not_of". this is beginning of token
        lastPos = str.find_first_not_of(delims, pos);
        // Find next delimiter at end of token.
        pos     = str.find_first_of(delims, lastPos);
    }
    
    return tokens;
}
float * EmptyVector(){return EmptyVector(3);}
float * EmptyVector(int n){
    //float * V=new float[3];
    float * V=(float*)malloc(n * sizeof (float));
    for(int i=0;i<n;i++)V[i]=0.0;
    return V;
}


char * ReadArg(int argc, char* argv[] , string Name){
    Name="--"+Name;
    for(int a=1;a<argc-1;a++)
        if(strcmp(Name.c_str(),argv[a])==0)
            return argv[a+1];
    
    printf(" PB IN ARGUMENT -> '%s' NO EXIST \n",Name.c_str());
    exit(0);
    return "";
}
