/* BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
#include "itkRGBPixel.h"
#include "itkImageFileWriter.h"
#include "itkImage.h"
#include "itkImageFileReader.h"
#include "itkImageRegionConstIterator.h"
#include "itkImageRegionIterator.h"


#include "dirent.h"
#include "string.h"
#include "stdio.h"
#include "stdlib.h"
#include "sys/stat.h"

using namespace std;

//Test if a file exist
bool exists(string file_name);
char * ReadArg(int argc, char* argv[] , string Name);

int main( int argc, char *argv[] )
{
    
    if(argc<3){
        printf("COMMAND : MergeVTK --inputpattern <inputfilepattern> --outputfile <outputfile>  --SpacingX <SpacingX> --SpacingY <SpacingY> --SpacingZ <SpacingZ> --ImageSizeX <ImageSizeX> --ImageSizeY <ImageSizeX> --ImageSizeZ <ImageSizeZ> \n");
        return -1;
    }
    char * inputfile=ReadArg(argc,argv,"inputpattern");
    char * outputfile=ReadArg(argc,argv,"outputfile");
    
    int threshold=128;
    typedef unsigned char InputPixelType;
    typedef itk::Image< InputPixelType,  3 > InputImageType;
    typedef itk::ImageFileReader< InputImageType > ReaderType;
    typedef itk::ImageRegionIterator< InputImageType> IteratorType;
    
    typedef int OutputPixelType;
    typedef itk::Image< OutputPixelType,  3 > OutputImageType;
    
    typedef itk::ImageFileWriter< OutputImageType > WriterType;
    
    
    OutputImageType::SpacingType Spacing;
    Spacing[0]=atof(ReadArg(argc,argv,"SpacingX"));
    Spacing[1]=atof(ReadArg(argc,argv,"SpacingY"));
    Spacing[2]=atof(ReadArg(argc,argv,"SpacingZ"));
    
    OutputImageType::SizeType Size;
    Size[0]=atof(ReadArg(argc,argv,"ImageSizeX"));
    Size[1]=atof(ReadArg(argc,argv,"ImageSizeY"));
    Size[2]=atof(ReadArg(argc,argv,"ImageSizeZ"));
    
    OutputImageType::IndexType Start;
    Start[0]=0;
    Start[1]=0;
    Start[2]=0;
    
    //Create the region
    OutputImageType::RegionType region(Start, Size);
    //Create an empty Image
    OutputImageType::Pointer image = OutputImageType::New();
    image->SetRegions(region);
    image->SetSpacing(Spacing);
    image->Allocate();
    image->FillBuffer(0);
  
     InputImageType::IndexType idx;
    //Read all segmented file
    int count=1;
    char file_name[400];
    sprintf(file_name,inputfile,count);
    while(exists(file_name)){
        //printf(" READ %s \n",file_name);
        ReaderType::Pointer reader=ReaderType::New();
        reader->SetFileName( file_name);
        reader->Update();
        InputImageType::Pointer im = reader->GetOutput();
        im->Update();
        InputImageType::PointType inputOrigin = im->GetOrigin();
        InputImageType::SizeType smallsize = im->GetLargestPossibleRegion().GetSize();
        //printf(" Cell %d inputOrigin=%f %f %f ->  size=%d %d %d \n",count,inputOrigin[0],inputOrigin[1],inputOrigin[2],smallsize[0],smallsize[1],smallsize[2]);
         int pp=0;

        for( idx[0]=0;idx[0]<smallsize[0];idx[0]++)
            for( idx[1]=0;idx[1]<smallsize[1];idx[1]++)
                for( idx[2]=0;idx[2]<smallsize[2];idx[2]++){
                    InputImageType::PixelType px=im->GetPixel(idx);
                    if(px>threshold){
                         OutputImageType::IndexType idxx;
                         idxx[0]=(int)round(idx[0]+inputOrigin[0]/Spacing[0]);  if(idxx[0]>=Size[0])idxx[0]=Size[0]-1;
                         idxx[1]=(int)round(idx[1]+inputOrigin[1]/Spacing[1]);  if(idxx[1]>=Size[1])idxx[1]=Size[1]-1;
                         idxx[2]=(int)round(idx[2]+inputOrigin[2]/Spacing[2]);  if(idxx[2]>=Size[2])idxx[2]=Size[2]-1;
                         image->SetPixel(idxx,count);
                         pp++;
     
                    }
                }

        
       // printf(" Cell number %d has %d pixels \n",count,pp);
        count++;sprintf(file_name,inputfile,count);
    }
    image->Update();
    WriterType::Pointer writer = WriterType::New();
    writer->SetFileName(outputfile);
    writer->SetInput(image);
    
    
    try
    {
        writer->Update();
        printf(" Write %s \n",outputfile);
    }
    catch( itk::ExceptionObject & excp )
    {
        printf(" CANNOT Write %s \n",outputfile);
        std::cerr << "Exception caught " << excp << std::endl;
        return 1;
    }
    
    
    
    
    return 0;
    
}

char * ReadArg(int argc, char* argv[] , string Name){
    Name="--"+Name;
    for(int a=1;a<argc-1;a++)
        if(strcmp(Name.c_str(),argv[a])==0)
            return argv[a+1];
    
    printf(" PB IN ARGUMENT -> '%s' NO EXIST \n",Name.c_str());
    exit(0);
    return "";
}

bool exists(string file_name)
{
    ifstream file_stream(file_name.c_str(),
                         ifstream::in);
    bool ans = file_stream.is_open();
    file_stream.close();
    return ans;
    //return true;
}
