#!/bin/bash

# GSubSurf - Generalized Subjective Surface Method for segmentation in 3D 
# Written in 2015 by Karol Mikula mikula@math.sk
# Robert Spir spir.robert@gmail.com
# Mariana Remesikova remesikova@math.sk
# Alessandro Sarti alessandro.sarti@ehess.fr
# 
# To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
# You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.

PATHDESTINATION=$1
BIOALGOS="${PATHDESTINATION}/Algorithmes/"
MPI="${PATHDESTINATION}/lib/MPICH/mpich/bin/mpicc"


mkdir ../EXE


${MPI} -o ../EXE/segm_nuclei ../SRC/segm_nuclei.c -lm

if [ $? -ne 0 ]; then
  echo "BioEmergences - NuceiSegmentation compilation failed"
  exit -1
fi

 echo "BioEmergences - NuceiSegmentation compilation OK"
 exit 0
