/* SimAnn - Simulated Annealing Method for cell tracking in 3D+time 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * Paul Bourgine paul.bourgine@polytechnique.edu
 * Alessandro Sarti alessandro.sarti@ehess.fr
 * Camilo Melani camilomelani@gmail.com
 * Rene Doursat rene.doursat@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
#ifndef __box3d_h
#define __box3d_h

#include <iostream>
#include <vector>
#include <set>


/*!
 * @file BoxType3d.h
 * @brief Contains class BoxType3d
 * @see BoxType3d
 */

/*!
 * @class BoxType3d "BoxType3d.h"
 * @brief todo: describe this class
 */

class  BoxType3d
{
public:
  /*! Self-type */
    typedef BoxType3d Self;
	
public:
  /*! @brief Default constructor */
  BoxType3d(){};
  
  /*! @brief Default destructor */
  ~BoxType3d(){};
  
  /*!
   * @brief todo: describe function
   * @param value todo: describe param
   * @see min
   */
  void SetMin(std::vector<double> value) {this->min[0] = value[0];this->min[1] = value[1];this->min[2] = value[2];};
  
  /*!
   * @brief todo: describe function
   * @param value todo: describe param
   */
  void SetMax(std::vector<double> value) {this->max[0] = value[0];this->max[1] = value[1];this->max[2] = value[2];};
  
  /*!
   * @brief todo: describe function
   * @param value: describe param
   */ 
  void SetTimeInit(long value) {timeInit = value;};
  
  /*!
   * @brief todo: describe function
   * @param value: describe parameter
   */
  void SetTimeEnd(long value) {timeEnd = value;};
  
  /*!
   * @brief get the timeInit member of this class
   * @see timeInit
   */
  long GetTimeInit() {return timeInit ;};
  
  /*!
   * @brief get the timeEnd member of this class
   * @see timeEnd
   */
  long GetTimeEnd() {return timeEnd ;};

  /*!
   * @brief set the numRegions member of this class
   * @see numRegions
   */
  void SetNumRegions(long value[3]) {this->numRegions[0] = value[0];this->numRegions[1] = value[1];this->numRegions[2] = value[2];};
  
  /*!
   * @brief Get the numRegions member of this class
   * @see numRegions
   */
  long *GetNumRegions() {return this->numRegions;};
  
  /*!
   * @brief Get the total number of regions of this object
   * @see numRegions
   * @return returns numRegions[0]*numRegions[1]*numRegions[2]
   */
  long GetTotalNumRegions() {return this->numRegions[0]*this->numRegions[1]*this->numRegions[2];};

  /*!
   * @brief Set the buffer values of this object
   * @see buffer
   * @param value todo: describe parameter
   */
  void SetBuffer(double value[3]) {this->buffer[0] = value[0];this->buffer[1] = value[1];this->buffer[2] = value[2];};
  
  /*!
   * @brief Get the buffer values of this object
   * @see buffer
   */
  double *GetBuffer() {return this->buffer;};
  
  /*!
   * @brief todo: describe function
   * @param i todo: describe param
   * @param j todo: describe param
   * @param k todo: describe param
   * @return todo: describe returned data
   */
  long GetRegionNumber(long i, long j, long k) {return
    this->GetNumRegions()[0]*this->GetNumRegions()[1]*i +
	this->GetNumRegions()[1]*j +
	k ;
  };
  
  /*!
   * @brief todo: describe function
   * @param x todo: describe param
   * @param y todo: describe param
   * @param z todo: describe param
   * @param regionNumber todo: describe param
   */
  bool IsInsideBuffer(double x,double y,double z, long regionNumber)
  {
    long i = regionNumber/(numRegions[1]*numRegions[2]);
    long ir = regionNumber % (numRegions[1]*numRegions[2]);
	  
    long j = ir/(numRegions[2]);
    long jr = ir % (numRegions[2]);

    long k = jr;
    
    double mx = (max[0]-min[0])/numRegions[0];
    double my = (max[1]-min[1])/numRegions[1];
    double mz = (max[2]-min[2])/numRegions[2];
	  
    if (((i * mx)+min[0] - buffer[0]<=x) && x < (((i+1) * mx)+min[0] + buffer[0])&&
	((j * my)+min[1] - buffer[1]<=y) && y < (((j+1) * my)+min[1] + buffer[1])&&
	((k * mz)+min[2] - buffer[2]<=z) && z < (((k+1) * mz)+min[2] + buffer[2]))
    {
	    return true;
    }
    else
    {
	    return false;
    }
  };
  
  /*!
   * @brief todo: describe function
   * @param x todo: describe param
   * @param y todo: describe param
   * @param z todo: describe param
   * @param regionNumber todo: describe param
   */
  bool IsInside(double x,double y,double z, long regionNumber)
  {
    long i = regionNumber/(numRegions[1]*numRegions[2]);
    long ir = regionNumber % (numRegions[1]*numRegions[2]);
	  
    long j = ir/(numRegions[2]);
    long jr = ir % (numRegions[2]);

    long k = jr;
    
    double mx = (max[0]-min[0])/numRegions[0];
    double my = (max[1]-min[1])/numRegions[1];
    double mz = (max[2]-min[2])/numRegions[2];
	  
    if (((i * mx)+min[0] <=x) && x < (((i+1) * mx)+min[0] )&&
	((j * my)+min[1] <=y) && y < (((j+1) * my)+min[1] )&&
	((k * mz)+min[2] <=z) && z < (((k+1) * mz)+min[2] ))
    {
      return true;
    }
    else
    {
      return false;
    }
  };
  
  private:
    /*! todo: describe private member */
    double min[3];
	
    /*! todo: describe private member */	
    double max[3];

    /*! todo: describe private member */	
    long numRegions[3];
	
    /*! todo: describe private member */	
    double buffer[3];
	
    /*! todo: describe private member */	
    long  timeInit;
	
    /*! todo: describe private member */	
    long  timeEnd;	

    //todo: This function is a dummy function?
    /*!
     * @brief todo: describe function
     * @tparam Archive todo: describe template parameter and restrictions on such
     * @param ar todo: describe param
     * @param version: todo: describe param format
     */
    template<class Archive> void serialize(Archive & ar, const unsigned int version)
    {
	//	ar & BOOST_SERIALIZATION_NVP(cell_number);
    }
};
#endif


