/* SimAnn - Simulated Annealing Method for cell tracking in 3D+time 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * Paul Bourgine paul.bourgine@polytechnique.edu
 * Alessandro Sarti alessandro.sarti@ehess.fr
 * Camilo Melani camilomelani@gmail.com
 * Rene Doursat rene.doursat@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
#ifndef __box4d_h
#define __box4d_h

#include <iostream>
#include <vector>
#include <set>

/*! 
 * @file BoxType4d.h
 * @brief contains BoxType4d class declaration
 * @see BoxType4d
 */

/*!
 * @class BoxType4d "BoxType4d.h"
 * @brief todo: describe class
 */
class  BoxType4d
{
  public:
    /*! Self-type */
    typedef BoxType4d Self;

  public:
    /*! default constructor */
    BoxType4d() : buffer ( std::vector< double > ( 4, 0 ) ) {};
    
    /*! default destructor */
    ~BoxType4d() {};

    /*! 
     * @brief Setter for min
     * @see min
     * @param value todo: describe param
     */
    void SetMin ( std::vector< double > value )
    {
      this->min.resize ( 4 );
      this->min[0] = value[0];
      this->min[1] = value[1];
      this->min[2] = value[2];
      this->min[3] = value[3];
    };
    
    /*!
     * @brief setter for max
     * @see max
     * @param value todo: describe param
     */
    void SetMax ( std::vector< double > value )
    {
      this->max.resize ( 4 );
      this->max[0] = value[0];
      this->max[1] = value[1];
      this->max[2] = value[2];
      this->max[3] = value[3];
    };
    
    /*!
     * @brief setter for buffer
     * @see buffer
     * @param value todo: describe param
     */
    void SetBuffer ( std::vector< double > value )
    {
      this->buffer.resize ( 4 );
      this->buffer[0] = value[0];
      this->buffer[1] = value[1];
      this->buffer[2] = value[2];
      this->buffer[3] = value[3];
    };

    /*!
     * @brief getter for buffer
     * @see buffer
     * @param value todo: describe param
     */
    std::vector< double > GetBuffer()
    {
      return this->buffer;
    };
    
    /*!
     * @brief getter for min
     * @see min
     * @return todo: describe return
     */
    std::vector< double > GetMin()
    {
      return this->min;
    };
    
    /*!
     * @brief getter for max
     * @see max
     * @return todo: describe return
     */
    std::vector< double > GetMax()
    {
      return this->max;
    };

    //	void SetSpacing(double value[3]) {this->spacing[0] = value[0];this->spacing[1] = value[1];this->spacing[2] = value[2];};
    //	double *GetSpacing() {return this->spacing;};

    /*! 
     * @brief setter for numRegions
     * @see numRegions
     * @param value todo: describe param
     */
    void SetNumRegions ( std::vector< long > value )
    {
      this->numRegions.resize ( 4 );
      this->numRegions[0] = value[0];
      this->numRegions[1] = value[1];
      this->numRegions[2] = value[2];
      this->numRegions[3] = value[3];
    };
    
    /*!
     * @brief getter for numRegions
     * @see numRegions
     * @return todo: describe return value
     */
    std::vector< long > GetNumRegions()
    {
      return this->numRegions;
    };
    
    /*!
     * @brief Get total number of regions for this object
     * @see numRegions
     * @return todo: describe return value
     */
    long GetTotalNumRegions()
    {
      return this->numRegions[0]*this->numRegions[1]*this->numRegions[2]*this->numRegions[3];
    };

    /*!
     * @brief todo: write function description
     * @param i todo: describe parameter
     * @param j todo: describe parameter
     * @param k todo: describe parameter
     * @param t todo: describe parameter
     * @return todo: describe return value
     */
    long GetRegionNumber ( long i, long j, long k, long t )
    {
      return this->GetNumRegions() [0]*this->GetNumRegions() [1]*i +
             this->GetNumRegions() [1]*j + this->GetNumRegions() [2] * k + t  ;
    };

    /*        bool IsInsideBuffer(double x,double y,double z, long regionNumber)
            {
              long i = regionNumber/(numRegions[1]*numRegions[2]);
              long ir = regionNumber % (numRegions[1]*numRegions[2]);

              long j = ir/(numRegions[2]);
              long jr = ir % (numRegions[2]);

              long k = jr;

              double mx = (max[0]-min[0])/numRegions[0];
              double my = (max[1]-min[1])/numRegions[1];
              double mz = (max[2]-min[2])/numRegions[2];

              if (((i * mx)+min[0] - buffer[0]<=x) && x < (((i+1) * mx)+min[0] + buffer[0])&&
                  ((j * my)+min[1] - buffer[1]<=y) && y < (((j+1) * my)+min[1] + buffer[1])&&
                  ((k * mz)+min[2] - buffer[2]<=z) && z < (((k+1) * mz)+min[2] + buffer[2]))
              {
                      return true;
              }
              else
              {
                      return false;
              }
            };*/

    /*! 
     * @brief Get distance from point in cartesian space
     * @param x todo: describe parameter
     * @param y todo: describe parameter
     * @param z todo: describe parameter
     * @return todo: describe return value
     */ 
    double Distance ( double x, double y, double z )
    {
      std::vector < double > vecCoorDist ( 6 );

      vecCoorDist[0] = fabs ( x - min[0] );
      vecCoorDist[1] = fabs ( y - min[1] );
      vecCoorDist[2] = fabs ( z - min[2] );
      vecCoorDist[3] = fabs ( x - max[0] );
      vecCoorDist[4] = fabs ( y - max[1] );
      vecCoorDist[5] = fabs ( z - max[2] );

      std::vector< double >::const_iterator it = min_element ( vecCoorDist.begin(), vecCoorDist.end() );

      return *it;
    }


    /*!
     * @brief todo: Describe function
     * @param x todo: Describe parameter
     * @param y todo: Describe parameter
     * @param z todo: Describe parameter
     */
    bool IsInside ( double x, double y, double z, double t, long regionNumber )
    {

      long i = regionNumber / ( numRegions[1] * numRegions[2] * numRegions[3] );
      long ir = regionNumber % ( numRegions[1] * numRegions[2] * numRegions[3] );

      long j = ir / ( numRegions[2] * numRegions[3] );
      long jr = ir % ( numRegions[2] * numRegions[3] );

      long k = jr / ( numRegions[3] );
      long kr = jr % ( numRegions[3] );

      long l = kr;

      double mx = double ( max[0] - min[0] ) / numRegions[0];
      double my = double ( max[1] - min[1] ) / numRegions[1];
      double mz = double ( max[2] - min[2] ) / numRegions[2];
      double mt = double ( max[3] - min[3] ) / numRegions[3];

      if ( ( ( i * mx ) + min[0] - buffer[0] <= x ) && x < ( ( ( i + 1 ) * mx ) + min[0] + buffer[0] ) &&
           ( ( j * my ) + min[1] - buffer[1] <= y ) && y < ( ( ( j + 1 ) * my ) + min[1] + buffer[1] ) &&
           ( ( k * mz ) + min[2] - buffer[2] <= z ) && z < ( ( ( k + 1 ) * mz ) + min[2] + buffer[2] ) &&
           ( ( l * mt ) + min[3] - buffer[3] <= t ) && t < ( ( ( k + 1 ) * mt ) + min[3] + buffer[3] )
         )
      {
        return true;
      }
      else
      {
/*
        std::cout << "Region Number "<< regionNumber << " i: "<< i << " j: " << j << " k: " << k << " l: " << l;
        std::cout <<  " mx: "<< mx << " my: " << my << " mz: " << mz << " mt: " << mt;
        std::cout <<  " min: " <<  min[0]  << " " << min[1] << " " << min[2] << " " << min[3];
        std::cout <<  " max: " <<  max[0]  << " " << max[1] << " " << max[2] << " " << max[3];
        std::cout <<  " x: " <<  x << " "<< y << " " << z << " " << t;
        std::cout << std::endl;
*/
        
        return false;
      }
    };
    
    
    /*!
     * @brief todo: write function description
     * @param regionNumber todo: describe param
     */
    void Limits ( long regionNumber )
    {
      long i = regionNumber / ( numRegions[1] * numRegions[2] * numRegions[3] );
      long ir = regionNumber % ( numRegions[1] * numRegions[2] * numRegions[3] );

      long j = ir / ( numRegions[2] * numRegions[3] );
      long jr = ir % ( numRegions[2] * numRegions[3] );

      long k = jr / ( numRegions[3] );
      long kr = jr % ( numRegions[3] );

      long l = kr;

      double mx = ( max[0] - min[0] ) / numRegions[0];
      double my = ( max[1] - min[1] ) / numRegions[1];
      double mz = ( max[2] - min[2] ) / numRegions[2];
      double mt = ( max[3] - min[3] ) / numRegions[3];

      std::cout << "X: " <<  ( i * mx ) + min[0] - buffer[0] << " " << ( ( i + 1 ) * mx ) + min[0] + buffer[0] << std::endl;
      std::cout << "Y: " <<  ( j * my ) + min[1] - buffer[1] << " " << ( ( j + 1 ) * my ) + min[1] + buffer[1] << std::endl;
      std::cout << "Z: " <<  ( k * mz ) + min[2] - buffer[2] << " " << ( ( k + 1 ) * mz ) + min[2] + buffer[2] << std::endl;
      std::cout << "T: " <<  ( l * mt ) + min[3] - buffer[3] << " " << ( ( k + 1 ) * mt ) + min[3] + buffer[3] << std::endl;
    };

    

  private:
    /*! todo: write description */
    std::vector< double > min;
    
    /*! todo: write description */
    std::vector< double > max;
    
    /*! todo: write description */
    std::vector< double > buffer;
    
    /*! todo: write description */
    std::vector< long > numRegions;
//        long  timeInit;
//        long  timeEnd;


    //	std::ostream& operator<< (std::ostream& ofs,const CellRealVirtual& Cell);
    
    /*!
     * @brief class serializer function
     * @tparam Archive todo: describe type parameter
     * @param ar todo: describe parameter
     * @param version todo: describe parameter
     */
    template<class Archive> void serialize ( Archive & ar, const unsigned int version )
    {
      ar & min & max & buffer & numRegions;
    }
};
#endif


