/* SimAnn - Simulated Annealing Method for cell tracking in 3D+time 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * Paul Bourgine paul.bourgine@polytechnique.edu
 * Alessandro Sarti alessandro.sarti@ehess.fr
 * Camilo Melani camilomelani@gmail.com
 * Rene Doursat rene.doursat@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
#ifndef __parameters_h
#define __parameters_h


#include <string.h>
#include <vector>
#include <string>
#include <list>



int const BorderMargeX=2;
int const BorderMargeY=2;
int const BorderMargeZ=2;

int const ImageSizeX=512;
int const ImageSizeY=512;
int const ImageSizeZ=74;

float const SpaceX=1.37;
float const SpaceY=1.37;
float const SpaceZ=1.37;


int const NbEvolutionWindows=20;


int const NbPhases=7;
int const NbMorphoFields=2;
int const NbSegmentation=2;

int const NbFeatures=31;

int const MaximumDistanceFeatures=20;

inline std::vector<std::string> InitListFields(){

    std::vector<std::string> ListFields;
	ListFields.push_back("x");
	ListFields.push_back("y");
	ListFields.push_back("z");
/*	ListFields.push_back("VELOCITYX");
	ListFields.push_back("VELOCITYY");
	ListFields.push_back("VELOCITYZ");
*/	ListFields.push_back("volumn");
	ListFields.push_back("volumn_neighbor");
	ListFields.push_back("volumn_deviation");

	
	ListFields.push_back("surfacearea");
	ListFields.push_back("normalizeshapeindex");

/*	ListFields.push_back("axeslength_r1");
	ListFields.push_back("axeslength_r2");
	ListFields.push_back("axeslength_r3");
	
	ListFields.push_back("axes_v1_r1");
	ListFields.push_back("axes_v1_r2");
	ListFields.push_back("axes_v1_r3");
	ListFields.push_back("axes_v2_r1");
	ListFields.push_back("axes_v2_r2");
	ListFields.push_back("axes_v2_r3");
	ListFields.push_back("axes_v3_r1");
	ListFields.push_back("axes_v3_r2");
	ListFields.push_back("axes_v3_r3");
					  
	ListFields.push_back("x_gravity");
	ListFields.push_back("y_gravity");
	ListFields.push_back("z_gravity");
	
	ListFields.push_back("distance_center_gravity");
*/	
	ListFields.push_back("intensity_mean");
	ListFields.push_back("intensity_maximum");
	ListFields.push_back("intensity_minimum");
	ListFields.push_back("intensity_sigma");
	ListFields.push_back("intensity_sum");
	
	ListFields.push_back("intensity_mean_neighbor");
	ListFields.push_back("intensity_mean_deviation");
	ListFields.push_back("intensity_mean_contour");
	ListFields.push_back("intensity_maximum_contour");
	ListFields.push_back("intensity_minimum_contour");
	ListFields.push_back("intensity_sigma_contour");
	ListFields.push_back("intensity_sum_contour");
	
	ListFields.push_back("INTENSITY_SIGMA_NEIGHBOR");		
	ListFields.push_back("INTENSITY_SIGMA_DEVIATION");
	ListFields.push_back("INTENSITY_SIGMA_COUNTOUR_DEVIA");
	ListFields.push_back("INTENSITY_MEAN_COUNTOUR_DEVIA");
	ListFields.push_back("INTENSITY_SIGMA_COUNTOUR_NEIGH");
	ListFields.push_back("INTENSITY_MEAN_COUNTOUR_NEIGH");
return ListFields;



};

inline std::vector<std::string> InitParameters(){
	std::vector<std::string> Parameters;
	Parameters.push_back("volumn");
	Parameters.push_back("volumn_neighbor");
	Parameters.push_back("volumn_deviation");
	Parameters.push_back("normalizeshapeindex");
	Parameters.push_back("intensity_mean");
	Parameters.push_back("intensity_maximum");
	Parameters.push_back("intensity_minimum");
	Parameters.push_back("intensity_sigma");
	Parameters.push_back("intensity_sum");
		
	Parameters.push_back("intensity_mean_neighbor");
	Parameters.push_back("intensity_mean_deviation");
	Parameters.push_back("intensity_mean_contour");
	Parameters.push_back("intensity_maximum_contour");
	Parameters.push_back("intensity_minimum_contour");
	Parameters.push_back("intensity_sigma_contour");
	Parameters.push_back("intensity_sum_contour");
	
	Parameters.push_back("INTENSITY_SIGMA_NEIGHBOR");		
	Parameters.push_back("INTENSITY_SIGMA_DEVIATION");
	Parameters.push_back("INTENSITY_SIGMA_COUNTOUR_DEVIA");
	Parameters.push_back("INTENSITY_MEAN_COUNTOUR_DEVIA");
	Parameters.push_back("INTENSITY_SIGMA_COUNTOUR_NEIGH");
	Parameters.push_back("INTENSITY_MEAN_COUNTOUR_NEIGH");
	return Parameters;
};

int const NbList=42;

inline std::vector<std::string> InitDownloadFields(){
	
	std::vector<std::string> ListDownloadFields;
	ListDownloadFields.push_back("x");
	ListDownloadFields.push_back("y");
	ListDownloadFields.push_back("z");
//	ListDownloadFields.push_back("VELOCITYX");
//	ListDownloadFields.push_back("VELOCITYY");
//	ListDownloadFields.push_back("VELOCITYZ");
	ListDownloadFields.push_back("volumn");
	ListDownloadFields.push_back("volumn_neighbor");
	ListDownloadFields.push_back("volumn_deviation");

	
	ListDownloadFields.push_back("surfacearea");
	ListDownloadFields.push_back("normalizeshapeindex");

	ListDownloadFields.push_back("axeslength_r1");
	ListDownloadFields.push_back("axeslength_r2");
	ListDownloadFields.push_back("axeslength_r3");
	
	ListDownloadFields.push_back("axes_v1_r1");
	ListDownloadFields.push_back("axes_v1_r2");
	ListDownloadFields.push_back("axes_v1_r3");
	ListDownloadFields.push_back("axes_v2_r1");
	ListDownloadFields.push_back("axes_v2_r2");
	ListDownloadFields.push_back("axes_v2_r3");
	ListDownloadFields.push_back("axes_v3_r1");
	ListDownloadFields.push_back("axes_v3_r2");
	ListDownloadFields.push_back("axes_v3_r3");
					  
	ListDownloadFields.push_back("x_gravity");
	ListDownloadFields.push_back("y_gravity");
	ListDownloadFields.push_back("z_gravity");
	
	ListDownloadFields.push_back("distance_center_gravity");
	
	ListDownloadFields.push_back("intensity_mean");
	ListDownloadFields.push_back("intensity_maximum");
	ListDownloadFields.push_back("intensity_minimum");
	ListDownloadFields.push_back("intensity_sigma");
	ListDownloadFields.push_back("intensity_sum");
	
	ListDownloadFields.push_back("intensity_mean_neighbor");
	ListDownloadFields.push_back("intensity_mean_deviation");
	ListDownloadFields.push_back("intensity_mean_contour");
	ListDownloadFields.push_back("intensity_maximum_contour");
	ListDownloadFields.push_back("intensity_minimum_contour");
	ListDownloadFields.push_back("intensity_sigma_contour");
	ListDownloadFields.push_back("intensity_sum_contour");
	
	ListDownloadFields.push_back("INTENSITY_SIGMA_NEIGHBOR");		
	ListDownloadFields.push_back("INTENSITY_SIGMA_DEVIATION");
	ListDownloadFields.push_back("INTENSITY_SIGMA_COUNTOUR_DEVIA");
	ListDownloadFields.push_back("INTENSITY_MEAN_COUNTOUR_DEVIA");
	ListDownloadFields.push_back("INTENSITY_SIGMA_COUNTOUR_NEIGH");
	ListDownloadFields.push_back("INTENSITY_MEAN_COUNTOUR_NEIGH");

	return ListDownloadFields;
}


inline int ValMorphoFields(std::string MorphoField){
	
	if(MorphoField=="normal") return 0;
	if(MorphoField=="epithelial") return 1;
	printf("Invalid ValMorphoFields");
	return -1;
	
}

inline std::string InValMorphoFields(int NMorpho){
	
	if(NMorpho==0) return "normal";
	if(NMorpho==1) return "epithelial";
	printf("Invalid InValMorphoFields");
	return "";
	
}

inline int ValPhases(std::string Phase){
	
	if(Phase=="interphase") return 0;
	if(Phase=="prophase") return 1;
	if(Phase=="prometaphase") return 2;
	if(Phase=="metaphase") return 3;
	if(Phase=="anaphase") return 4;
	if(Phase=="telophase") return 5;
	if(Phase=="cytokinesis") return 6;
	printf("Invalid ValPhases");
	return -1;
	
}

inline std::string  InValPhases(int NPhase){
	
	if(NPhase==0) return "interphase";
	if(NPhase==1) return "prophase";
	if(NPhase==2) return "prometaphase";
	if(NPhase==3) return "metaphase";
	if(NPhase==4) return "anaphase";
	if(NPhase==5) return "telophase";
	if(NPhase==6) return "cytokinesis";
	printf("Invalid InValPhases");
	return "";
}


inline int ValSegmentation(std::string Seg){
	
	if(Seg=="badsegmentation") return 0;
	if(Seg=="badcenter") return 1;
	printf("Invalid ValSegmentation");
	return -1;
	
}

inline std::string  InValSegmentation(int NbSeg){
	
	if(NbSeg==0) return "badsegmentation";
	if(NbSeg==1) return "badcenter";
	printf("Invalid InValSegmentation");
	return "";
	
}



	
#endif
