/* SimAnn - Simulated Annealing Method for cell tracking in 3D+time 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * Paul Bourgine paul.bourgine@polytechnique.edu
 * Alessandro Sarti alessandro.sarti@ehess.fr
 * Camilo Melani camilomelani@gmail.com
 * Rene Doursat rene.doursat@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
#ifndef EdgePropertyType_h
#define EdgePropertyType_h


#include <boost/config.hpp>
#include <boost/dynamic_bitset.hpp>
#include <boost/pending/indirect_cmp.hpp>
//#include <boost/range/irange.hpp>
#include <boost/serialization/map.hpp>
#include <boost/serialization/set.hpp>
#include <boost/pending/property_serialize.hpp>

#include <boost/pool/pool_alloc.hpp>

#include <boost/bind.hpp>
#include <boost/function.hpp>
#include <boost/lambda/lambda.hpp>
#include <boost/lambda/bind.hpp>
#include <boost/lambda/construct.hpp>
#include <boost/foreach.hpp>


#include <strstream>
#include <sstream>




/**
	@author Camilo Melani
	\brief The edges on the tree has this information
 */

    class EdgePropertyType
    {
      public:
        EdgePropertyType():m_probability(-1) {};
        ~EdgePropertyType() {};

        void SetProbability(double p_prob){this->m_probability = p_prob;};
        double GetProbability(){return this->m_probability;};

	double m_probability;

      private:
        friend class boost::serialization::access;
        template<class Archive> void serialize ( Archive & ar, const unsigned int version )
        {
		ar & m_probability;
        }
    };
#endif
