/* SimAnn - Simulated Annealing Method for cell tracking in 3D+time 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * Paul Bourgine paul.bourgine@polytechnique.edu
 * Alessandro Sarti alessandro.sarti@ehess.fr
 * Camilo Melani camilomelani@gmail.com
 * Rene Doursat rene.doursat@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
#ifndef imageprovider_h
#define imageprovider_h

#include <numeric>
#include <boost/foreach.hpp>
#include <itkImageFileReader.h>
#include <itkImage.h>

#include "itkImageFileReader.h"
#include <boost/format.hpp>
#include <boost/config.hpp>
#include <boost/serialization/map.hpp>
#include <boost/serialization/set.hpp>



/**
	@author
 */
 
const unsigned int Dimension = 3;
typedef unsigned char PixelType;
typedef itk::Image< PixelType, Dimension > ImageType;

class ImageProvider
{
  private:
    typedef ImageProvider Self;
    typedef itk::ImageFileReader< ImageType > ReaderType;
    typedef std::pair< long, long > KeyType;
    typedef std::map< KeyType, ImageType::Pointer > MapTimeImageType;
    
  public:
    void SetPattern(std::string pPattern);
    ImageProvider();
    ~ImageProvider();
    ImageType::Pointer GetImage(long ptime,long channel);

  private:
    std::string m_pattern;
    MapTimeImageType m_cache;
    std::string m_Directory;

    friend class boost::serialization::access;
    BOOST_SERIALIZATION_SPLIT_MEMBER()
    template<class Archive>
        void save ( Archive & ar, const unsigned int version ) const
    {
      ar << m_pattern;
    }

    template<class Archive>
        void load ( Archive & ar, const unsigned int version )
    {
      ar >> m_pattern;
      m_cache.clear();
    }
};
#endif
