/* SimAnn - Simulated Annealing Method for cell tracking in 3D+time 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * Paul Bourgine paul.bourgine@polytechnique.edu
 * Alessandro Sarti alessandro.sarti@ehess.fr
 * Camilo Melani camilomelani@gmail.com
 * Rene Doursat rene.doursat@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
#include <iostream>

#include <string>

#include <vector>

#include <algorithm>

using namespace std;





#include <boost/function.hpp>

#include <boost/bind.hpp>

#include <boost/shared_ptr.hpp>







class CommandType

{

 private:

	 boost::function<void ()> _f;

 public:

   CommandType() {;}

   CommandType(boost::function<bool  ()> f) : _f(f) {;}



	 template <typename T> void setFunction (T t) {_f = t;}

	 void execute()

	 {

	  if(!_f.empty())

			_f();

	 }

         		

         friend class boost::serialization::access;

         template<class Archive> void serialize ( Archive & ar, const unsigned int version )

         {

           ar & _f;

         }

};



