/* SimAnn - Simulated Annealing Method for cell tracking in 3D+time 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * Paul Bourgine paul.bourgine@polytechnique.edu
 * Alessandro Sarti alessandro.sarti@ehess.fr
 * Camilo Melani camilomelani@gmail.com
 * Rene Doursat rene.doursat@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */

#ifndef SingularCallBack_h
#define SingularCallBack_h

template < class Class, typename ReturnType, typename Parameter1 ,typename Parameter2 >
    class SingularCallBack
{
  public:

    typedef ReturnType (Class::*Method)(Parameter1,Parameter2);

    SingularCallBack(){};
    
    SingularCallBack(std::string p_name, double p_weight, Class* _class_instance, Method _method):
      class_instance(_class_instance),method(_method),name(p_name),weight(p_weight)
      {
    };

    ReturnType operator()(Parameter1 parameter1,Parameter2 parameter2)
    {
      return (class_instance->*method)(parameter1,parameter2) * GetWeight();
    };

    ReturnType execute(Parameter1 parameter1,Parameter2 parameter2)
    {
      return operator()(parameter1,parameter2);
    };

    std::string GetName()  {return this->name;};
    double GetWeight() {return this->weight;};
    
  private:
    friend class boost::serialization::access;
    template<class Archive> void serialize ( Archive & ar, const unsigned int version )
    {
      ar & class_instance;
      ar & method;
      ar & name;
      ar & weight;
    }

  private:

    Class*  class_instance;
    Method  method;
    std::string name;
    double weight;
};




template < class Class, typename ReturnType, typename Parameter1 = void,
                                             typename Parameter2 = void,
                                             typename Parameter3 = void,
                                             typename Parameter4 = void >
class CallBack
{

   public:

    typedef ReturnType (Class::*Method)(Parameter1, Parameter2, Parameter3, Parameter4);

    CallBack(std::string p_name, double p_weight, Class* _class_instance, Method _method):
      class_instance(_class_instance),method(_method),name(p_name),weight(p_weight)
      {
    };




    ReturnType operator()(Parameter1 p1, Parameter2 p2, Parameter3 p3, Parameter4 p4)
    {
      return (class_instance->*method)(p1, p2, p3, p4)* GetWeight();
    };

    ReturnType execute(Parameter1 p1, Parameter2 p2, Parameter3 p3, Parameter4 p4)
    {
       return operator()(p1, p2, p3, p4);
    };


    std::string GetName()  {return this->name;};
    double GetWeight() {return this->weight;};

    private:

    Class*  class_instance;
    Method  method;
    std::string name;
    double weight;

};



template < class Class, typename ReturnType, typename Parameter1,
                                             typename Parameter2,
                                             typename Parameter3>
class CallBack  < Class, ReturnType, Parameter1, Parameter2, Parameter3 >
{

   public:

    typedef ReturnType (Class::*Method)(Parameter1, Parameter2, Parameter3);

    CallBack(std::string p_name, double p_weight, Class* _class_instance, Method _method):
        class_instance(_class_instance),method(_method),name(p_name),weight(p_weight)
        {
        };

    ReturnType operator()(Parameter1 p1, Parameter2 p2, Parameter3 p3)
    {
      return (class_instance->*method)(p1, p2, p3)* GetWeight();
    };

    ReturnType execute(Parameter1 p1, Parameter2 p2, Parameter3 p3)
    {
       return operator()(p1, p2, p3);
    };
    
    std::string GetName()  {return this->name;};
    double GetWeight() {return this->weight;};

  private:

    Class*  class_instance;
    Method  method;
    std::string name;
    double weight;

};


template < class Class, typename ReturnType, typename Parameter1, typename Parameter2 >
class CallBack < Class, ReturnType, Parameter1, Parameter2 >
{

   public:

    typedef ReturnType (Class::*Method)(Parameter1,Parameter2);

    CallBack(std::string p_name, double p_weight, Class* _class_instance, Method _method):
        class_instance(_class_instance),method(_method),name(p_name),weight(p_weight)
        {
        };

    ReturnType operator()(Parameter1 p1, Parameter2 p2)
    {
      return (class_instance->*method)(p1, p2)* GetWeight();
    };

    ReturnType execute(Parameter1 p1, Parameter2 p2)
    {
       return operator()(p1, p2);
    };

    std::string GetName()  {return this->name;};
    double GetWeight() {return this->weight;};

  private:

    Class*  class_instance;
    Method  method;
    std::string name;
    double weight;

};


template < class Class, typename ReturnType, typename Parameter>
class CallBack < Class, ReturnType, Parameter >
{

   public:

    typedef ReturnType (Class::*Method)(Parameter);

    CallBack(std::string p_name, double p_weight, Class* _class_instance, Method _method):
        class_instance(_class_instance),method(_method),name(p_name),weight(p_weight)
        {
        };

    ReturnType operator()(Parameter p1)
    {
      return (class_instance->*method)(p1)* GetWeight();
    };

    ReturnType execute(Parameter p1)
    {
       return operator()(p1);
    };

    std::string GetName()  {return this->name;};
    double GetWeight() {return this->weight;};

  private:

    Class*  class_instance;
    Method  method;
    std::string name;
    double weight;

};


template < class Class, typename ReturnType>
class CallBack < Class, ReturnType >
{

   public:

    typedef ReturnType (Class::*Method)(void);

    CallBack(std::string p_name, double p_weight, Class* _class_instance, Method _method):
        class_instance(_class_instance),method(_method),name(p_name),weight(p_weight)
        {
        };

    ReturnType operator()()
    {
      return (class_instance->*method)()* GetWeight();
    };

    ReturnType execute()
    {
       return operator()();
    };

    std::string GetName()  {return this->name;};
    double GetWeight() {return this->weight;};

  private:

    Class*  class_instance;
    Method  method;
    std::string name;
    double weight;

};





#endif
