/* SimAnn - Simulated Annealing Method for cell tracking in 3D+time 
 * Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
 * Paul Bourgine paul.bourgine@polytechnique.edu
 * Alessandro Sarti alessandro.sarti@ehess.fr
 * Camilo Melani camilomelani@gmail.com
 * Rene Doursat rene.doursat@inaf.cnrs-gif.fr
 * 
 * To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
 * You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.
 */
#ifndef solution_h
#define solution_h

#include <cfloat>

/**
	@author
 */
template <class EPtr>
    class Solution
{
  private:
  public:
    Solution():m_energy(DBL_MAX){};
    ~Solution(){};
    
    typedef std::pair < EPtr  , EPtr  > SolutionElementType;
    typedef std::list < SolutionElementType > SolutionLinksType;
    
    typedef typename  SolutionLinksType::iterator iterator;
    
    iterator begin(){return listLinks.begin();};
    iterator end(){return listLinks.end();};
    
    void SetEnergy(double p_energy){this->m_energy = p_energy;};
    double GetEnergy(){return this->m_energy;};
    
    void Addlink(EPtr  from ,EPtr  to) {
            listLinks.push_back(std::make_pair(from, to) );
            };
            
            
            friend class boost::serialization::access;
            template<class Archive> void serialize ( Archive & ar, const unsigned int version )
            {
              ar & listLinks;
              ar & m_energy;
            }

  private:
    SolutionLinksType listLinks;
    
    double m_energy;
};




#endif
