#!/bin/bash

# BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
# Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
# 
# To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
# You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.

PATHDESTINATION=$1

#INSTALL BOOST
version="1.55.0"
cd "${PATHDESTINATION}/lib/BOOST/boost_${version}"
BOOST_HOME=`pwd`
MPICH_HOME="${PATHDESTINATION}/lib/MPICH/mpich/bin"
sh bootstrap.sh --prefix=${BOOST_HOME} 
echo "using mpi : ${MPICH_HOME}/mpicc ;" >> project-config.jam 


./b2 install --with-mpi --with-graph_parallel --with-system --with-serialization --with-filesystem --with-date_time --with-program_options --prefix="${BOOST_HOME}"  


echo  "BioEmergences - COMPILATION BOOST OK IN ${BOOST_HOME}"
