#! /bin/bash

# BioEmergences Workflow - A standalone workflow for embryo processing on personal computers 
# Written in 2015 by BioEmergences CNRS USR bioemergences@inaf.cnrs-gif.fr
# 
# To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide. This software is distributed without any warranty.
# You should have received a copy of the CC BY-NC-SA 4.0 Dedication along with this software. If not, see <https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>.

PATHDESTINATION=$1

os=$(uname)

if [ "$os" == "Darwin" ];
then
  mv "${PATHDESTINATION}/MovIT/moveit828.macosx/moveit828.app" "${PATHDESTINATION}/"
  rm -rf "${PATHDESTINATION}/MovIT"
elif [ "$os" == "Linux" ];
then
	vver="32"

  if [ "$(uname -m)" == "x86_64" ];
  then
		vver="64";
	fi

	mv "${PATHDESTINATION}/MovIT/moveit828.linux${vver}" "${PATHDESTINATION}/"
	rm -rf "${PATHDESTINATION}/MovIT"
	mv "${PATHDESTINATION}/moveit828.linux${vver}" "${PATHDESTINATION}/MovIT"
  
  echo '#! /bin/bash' > "${PATHDESTINATION}/movit"
  echo 'cd "$(dirname "$0")/MovIT"' >> "${PATHDESTINATION}/movit"
  echo './moveit828' >> "${PATHDESTINATION}/movit"

  chmod 755 "${PATHDESTINATION}/movit"
fi
